﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public static class SppUtility {

	public static Bounds GetBoundingBox (Transform t)
	{
		Bounds bound = new Bounds ();
		Bounds glbBound = new Bounds ();
		MeshRenderer[] renderers;
		bool initBound = false;

		renderers = t.GetComponentsInChildren<MeshRenderer> ();
		foreach (MeshRenderer r  in renderers) {
			bound = r.bounds; 
			if (initBound) {
				glbBound.Encapsulate (bound.min);
				glbBound.Encapsulate (bound.max);    	
			} else {
				glbBound.min = new Vector3 (bound.min.x, bound.min.y, bound.min.z);
				glbBound.max = new Vector3 (bound.max.x, bound.max.y, bound.max.z);
				initBound = true;
			}
		}
		return glbBound;
	}

	public static void  CenterModel (GameObject instanced, bool adjustCamera)
	{
		try {
			// Get model bounds
			if (instanced != null) {
				// BB
				Bounds modelBounds = GetBoundingBox (instanced.transform);
				// center
				instanced.transform.position = modelBounds.center * -1f;
				// BB
				modelBounds = GetBoundingBox (instanced.transform);
				// Calculate distance
				float max = modelBounds.size.x;
				if (modelBounds.size.y > max) {
					max = modelBounds.size.y;
				} else if (modelBounds.size.z > max) {
					max =modelBounds.size.z;
				}
				Camera.main.transform.LookAt (instanced.transform.position);
				Camera.main.transform.position = modelBounds.center + (Vector3.back * max);
				if (adjustCamera == true) {
					Camera.main.SendMessage ("SetDistanceMin", max * 0.5,  SendMessageOptions.DontRequireReceiver);
					Camera.main.SendMessage ("SetDistanceMax", max * 4, SendMessageOptions.DontRequireReceiver);
					Camera.main.SendMessage ("CamDistance", max, SendMessageOptions.DontRequireReceiver);
				}
			}	
		} catch (System.Exception e) {
			Debug.Log ("ERROR: CenterModel=> " + e.Message);
		}
	}

	public static string CombinePath(string prefix, string postfix) {
		if (!prefix.EndsWith("/"))
			prefix = prefix + "/";
		postfix = postfix.Trim('/');
		return (prefix+postfix);
	}

	public static string BuildModelServerPath(string server, string catalog, string model, string subFolder) {
		string path = server;
		path = CombinePath (path, "company");
		path = CombinePath (path, catalog.ToLower());
		path = CombinePath (path, model);
		path = CombinePath (path, "data");
		path = CombinePath (path, subFolder);
		return path;
	}	

	public static string BuildModelLocalPath(string model, string subFolder) {
#if UNITY_WSA
        string path = "";
#else
        string path = System.Environment.GetFolderPath(System.Environment.SpecialFolder.Personal);
#endif
        path = CombinePath (path, "SparePartsPlace");
		path = CombinePath (path, "SPPV");
		path = CombinePath (path, model);
		path = CombinePath (path, "data");
		path = CombinePath (path, subFolder);
		path = path.Replace ("\\", "/");

		return "file:///" + path;
    }	

	public static void CleanUp () {
		Resources.UnloadUnusedAssets();
		System.GC.Collect();
		System.GC.WaitForPendingFinalizers();
	}

	public static string NameFromId (int id) {
		string s = "00000" + id.ToString ();
		s = s.Substring (s.Length - 6, 6);
		return s;
	}

	public static int IdFromName(string name) {
		try {
			int idx = System.Convert.ToInt32(name.Substring(0,6));
			return idx-1;
		} catch {
			return -1;
		}	
	}

}
